#!/usr/bin/perl -w

package main;

use strict;

use vars qw($TESTING);
$TESTING = 1;
use Test::More tests => 12;
use constant DEBUG => 0;

use File::Glob;

# force the output to return for testing
$ENV{CGI_APP_RETURN_ONLY} = 1;

# make explicit the query string
$ENV{REQUEST_METHOD} = 'GET';

BEGIN {
  use_ok('CGI::Application');
  use_ok('CGI');
  use_ok('CGI::FormBuilder');
  use_ok('Handout');
  use_ok('File::Slurp');
}

{
        my $param = shift || "";
        my $redo = ( $param =~ /-r/ ) || 0;

	my $ho = CGI::Application->new();
	isa_ok($ho, 'CGI::Application');
        ok(ref($ho),"Check for valid CGI::Application reference");

        $ho = Handout->new( QUERY => CGI->new() );
	isa_ok($ho, 'CGI::Application');
	isa_ok($ho, 'Handout');
        ok(ref($ho),"Check for valid Handout reference");

	my @methods = ( 
			'select_handout',
			'select_topics',
			'select_info',
			'show_handout',
			'import_handout',
			'splash',
		);
        can_ok($ho, @methods);

        my $source = "";
        my @lines  = ();
        my @items  = ();
	my $okay   = 0;
      
	# login output
        $ENV{QUERY_STRING}   = '';			# 1st call
        print "QS: $ENV{QUERY_STRING}\n" if DEBUG; 
        $source = "t/login.out"; 
        $ho = Handout->new( QUERY => CGI->new( {} ));
        $okay = run( $source, $ho, \@lines, \@items );
        ok($okay, "Test Handout App login screen");

# run_command($command,$host,$init_timeout,$timeout);
    sub run {
   	my ($source, $ca, $lines, $items) = @_;

        my $target = $source;
        $target =~ s/out$/run/;
	unlink $target;

        @$lines = $ca->run();
	File::Slurp::write_file($target, @$lines);
	@$lines = File::Slurp::read_file($target);

	if ( ! -e $source || $redo ) {
	    @$items = $ca->run();
	    File::Slurp::write_file($source, @$items);
	    @$items = File::Slurp::read_file($source);
	} else {
	    @$items = File::Slurp::read_file($source);
	}
        my $okay = eq_array($lines,$items);
	if ( $okay ) {
	    unlink $target;
	} else {
	    diag("Check $target file for differences");
        }
    }
}

__END__


=head1 NAME

Handout test notes

=head1 SYNOPSIS

perl t/builder.t [-redo]

<web location>/output.pl

=head1 DESCRIPTION

Use the word "verify" to introduce each test section
   typically "verify <method name> ...

Use the Test::More so each test is clear
   typically give verb <methods> ... for action
   check, recheck, open, ...

Add all methods to the methods array

To see all output run the "output.pl" from the web
and it will show them.  It also turns on the GET
REQUEST_METHOD so screens may be debugged.

All screen output should produce a file named by
the "<test_name>.out".  Create each test with a
unique "<test_name>.cgi which uses a uniuqe
QUERY_STRING.

=head1 BUGS

=head1 AUTHOR

David Scott E<leapingfrog@yahoo.com>

=cut
