#!/usr/bin/perl -w

package main;

use strict;

use vars qw($TESTING);
$TESTING = 1;
use Test::More tests => 57;
use constant DEBUG => 0;

BEGIN {
#  use_ok('CGI');
#  use_ok('CGI::FormBuilder');
  use_ok('Info');
  use_ok('File::Slurp');
  use_ok('File::Copy');
}

{
	my $name   = "reading_test";
	my $import = "import_test";
	my $file   = "t/spleen";
	my $data_dir = "data";
        mkdir $data_dir unless -d $data_dir;
	my $file_dir .= "data/handout";
	my $filespec = $file_dir . "/" . $name;
        mkdir $file_dir unless -d $file_dir;

	# Get ready to test
	unlink "data/handout/$name", "data/handout/$import";
	File::Copy::copy($file, "$file_dir/${name}");

	# Verify normal read
        my $info = Info->new($name);
	isa_ok($info, 'Info');
        ok(ref($info),"Check for valid Info reference");

	my @methods = ( 
		'get_all',
		'new', 'import', 'init',
		'get_dir',
		'parse',
		'delete',
		'restore',
		'add_name',
		'topics', 'topic_options',
		'info', 'info_options', 'info_data',
		'show',
		);
        can_ok($info, @methods);

	# Verify topics
	my @topics = $info->topics;
	my $value = "topic_1";
	is ( join(" ",@topics), $value, "Check topic fields are there");

	# Verify topic_options
	my $topics = $info->topic_options;
	$value = "Weak / Damp Spleen";
	is ( $topics->{'topic_1'}->[0], $value, "Check topic option is there");

	# Verify info
	my @info = $info->info( ( 1 ) );
	$value = "topic_1 info_1_1 table_1_2 info_1_3 info_1_4 table_1_5";
	is ( join(" ",@info), $value, "Check info fields are there");

	# Verify info_data
	my $opts = $info->info_data( ( 1 ) );
	$value = "Weak / Damp Spleen";
	is ( $opts->{'topic_1'}->[0], $value, "Check info option is there");
	$value = "Avoid concentrated sweets";
	is ( $opts->{'info_1_1'}->[0], $value, "Check info option is there");
	$value = "Avoid energetically cold foods";
	is ( $opts->{'table_1_2'}->[0], $value, "Check info option is there");

	# Verify import read
        $info = Info->import($import,$file);
	isa_ok($info, 'Info');
        ok(ref($info),"Check import for valid Info reference");

	# Verify topics
	@topics = $info->topics;
	$value = "topic_1";
	is ( join(" ",@topics), $value, "Check topic fields are there");

	# Verify topic_options
	$topics = $info->topic_options;
	$value = "Weak / Damp Spleen";
	is ( $topics->{'topic_1'}->[0], $value, "Check topic option is there");

	# Verify info
	@info = $info->info( ( 1 ) );
	$value = "topic_1 info_1_1 table_1_2 info_1_3 info_1_4 table_1_5";
	is ( join(" ",@info), $value, "Check info fields are there");

	# Verify info_data
	$opts = $info->info_data( ( 1 ) );
	$value = "Weak / Damp Spleen";
	is ( $opts->{'topic_1'}->[0], $value, "Check info option is there");
	$value = "Avoid concentrated sweets";
	is ( $opts->{'info_1_1'}->[0], $value, "Check info option is there");
	$value = "Avoid energetically cold foods";
	is ( $opts->{'table_1_2'}->[0], $value, "Check info option is there");

	# Verify topic with single info
	my @data = (
		"topic Weak / Damp Spleen\n",
		"info Avoid concentrated sweets\n",
		"honey, sugar, molasses, maple syrup\n",
	);
	File::Slurp::write_file($filespec, @data );
        $info = Info->new($name);
	isa_ok($info, 'Info');
        ok(ref($info),"Check create of single Info reference");

	# Verify topics
	@topics = $info->topics;
	$value = "topic_1";
	is ( join(" ",@topics), $value, "Check topic fields are there");

	# Verify topic_options
	$topics = $info->topic_options;
	$value = "Weak / Damp Spleen";
	is ( $topics->{'topic_1'}->[0], $value, "Check topic option is there");

	# Verify info
	@info = $info->info( ( 1 ) );
	$value = "topic_1 info_1_1";
	is ( join(" ",@info), $value, "Check info fields are there");

	# Verify info_data
	$opts = $info->info_data( ( 1 ) );
	$value = "Weak / Damp Spleen";
	is ( $opts->{'topic_1'}->[0], $value, "Check info option is there");
	$value = "Avoid concentrated sweets";
	is ( $opts->{'info_1_1'}->[0], $value, "Check info option is there");
	$value = "honey, sugar, molasses, maple syrup";
	is ( $opts->{'info_1_1'}->[1], $value, "Check info option is there");

	# Verify topic with table row
	@data = (
		"topic Weak / Damp Spleen\n",
		"table rows Avoid energetically cold foods\n",
		"greens, grains\n",
		"celery, lettuce, cucumbers, spinach\n",
		"wheat, buckwheat, millet\n",
	);
	File::Slurp::write_file($filespec, @data );
        $info = Info->new($name);
	isa_ok($info, 'Info');
        ok(ref($info),"Check create for single table rows reference");

	# Verify topics
	@topics = $info->topics;
	$value = "topic_1";
	is ( join(" ",@topics), $value, "Check topic fields are there");

	# Verify topic_options
	$topics = $info->topic_options;
	$value = "Weak / Damp Spleen";
	is ( $topics->{'topic_1'}->[0], $value, "Check topic option is there");

	# Verify info
	@info = $info->info( ( 1 ) );
	$value = "topic_1 table_1_1";
	is ( join(" ",@info), $value, "Check info fields are there");

	# Verify info_data
	$opts = $info->info_data( ( 1 ) );
	$value = "Weak / Damp Spleen";
	is ( $opts->{'topic_1'}->[0], $value, "Check info option is there");
	$value = "Avoid energetically cold foods",
	is ( join(' ',$opts->{'table_1_1'}->[0]), 
		$value, "Check info option is there");
	$value = "greens grains";
	is ( join(' ',@{$opts->{'table_1_1'}->[1]}), 
		$value, "Check info option is there");
	$value = "celery lettuce cucumbers spinach";
	is ( join(' ',@{$opts->{'table_1_1'}->[2]}), 
		$value, "Check info option is there");
	$value = "wheat buckwheat millet";
	is ( join(' ',@{$opts->{'table_1_1'}->[3]}), 
		$value, "Check info option is there");

	# Verify topic with table column
	@data = (
		"topic Weak / Damp Spleen\n",
		"table columns Avoid energetically congesting foods\n",
		"dairy, cold\n",
		"milk, cheese\n",
		"pizza, ice cream\n",
	);
	File::Slurp::write_file($filespec, @data );
        $info = Info->new($name);
	isa_ok($info, 'Info');
        ok(ref($info),"Check create for single table columns reference");

	# Verify topics
	@topics = $info->topics;
	$value = "topic_1";
	is ( join(" ",@topics), $value, "Check topic fields are there");

	# Verify topic_options
	$topics = $info->topic_options;
	$value = "Weak / Damp Spleen";
	is ( $topics->{'topic_1'}->[0], $value, "Check topic option is there");

	# Verify info
	@info = $info->info( ( 1 ) );
	$value = "topic_1 table_1_1";
	is ( join(" ",@info), $value, "Check info fields are there");

	# Verify info_data
	$opts = $info->info_data( ( 1 ) );
	$value = "Weak / Damp Spleen";
	is ( $opts->{'topic_1'}->[0], $value, "Check info option is there");
	$value = "Avoid energetically congesting foods";
	is ( join(' ',$opts->{'table_1_1'}->[0]), 
		$value, "Check info option is there");
	$value = "dairy cold";
	is ( join(' ',@{$opts->{'table_1_1'}->[1]}), 
		$value, "Check info option is there");
	$value = "milk cheese";
	is ( join(' ',@{$opts->{'table_1_1'}->[2]}), 
		$value, "Check info option is there");
	$value = "pizza ice cream";
	is ( join(' ',@{$opts->{'table_1_1'}->[3]}), 
		$value, "Check info option is there");

	# Verify topic with info plus an image
	@data = (
		"topic Weak / Damp Spleen\n",
		"info Avoid concentrated sweets\n",
		"honey, sugar, molasses, maple syrup\n",
		"image horse.gif\n",
	);
	File::Slurp::write_file($filespec, @data );
        $info = Info->new($name);
	isa_ok($info, 'Info');
        ok(ref($info),"Check for valid image in single Info reference");

	# Verify topics
	@topics = $info->topics;
	$value = "topic_1";
	is ( join(" ",@topics), $value, "Check topic fields are there");

	# Verify topic_options
	$topics = $info->topic_options;
	$value = "Weak / Damp Spleen";
	is ( $topics->{'topic_1'}->[0], $value, "Check topic option is there");

	# Verify info
	@info = $info->info( ( 1 ) );
	$value = "topic_1 info_1_1";
	is ( join(" ",@info), $value, "Check info fields are there");

	# Verify info_data
	$opts = $info->info_data( ( 1 ) );
	$value = "Weak / Damp Spleen";
	is ( $opts->{'topic_1'}->[0], $value, "Check info option is there");
	$value = "Avoid concentrated sweets";
	is ( $opts->{'info_1_1'}->[0], $value, "Check info option is there");
	$value = "honey, sugar, molasses, maple syrup";
	is ( $opts->{'info_1_1'}->[1], $value, "Check info option is there");

	# Verify TO BE IMPLEMENTED
	$value = "image horse.gif";
	is ( $opts->{'info_1_1'}->[2], $value, "Check info option is there");

	# remove test files
	unlink "data/handout/$name", "data/handout/$import";
}

__END__


=head1 NAME

Info test notes

=head1 SYNOPSIS

perl t/info.t

=head1 DESCRIPTION

Use the word "verify" to introduce each test section
   typically "verify <method name> ...

Use the Test::More so each test is clear
   typically give verb <methods> ... for action
   check, recheck, open, ...

Add all methods to the methods array

Test each keyword capability in a simple file separately so
this identifies simple bugs to the parser through the show
routines.

=head1 BUGS

=head1 AUTHOR

David Scott E<leapingfrog@yahoo.com>

=cut
