#!/usr/bin/perl -w
use strict;

use File::Slurp;
use CGI;

my @output = glob('*.out');

my ($lines, $errout, $target, @target);
foreach my $output ( @output ) {
    $errout = $target = $output;
    $target =~ s/\.out$/.pl/;
    $errout =~ s/\.out$/.run/;
    open TARGET, "> $target" || die "Unable to write to $target: $!";
    print TARGET "#!/usr/bin/perl -w
use strict;

# Send $output to a web screen
";
    $lines = File::Slurp::read_file($output);
    $lines =~ s/\'/\\\'/g;
    $lines =~ s/method=\'POST/method=\'GET/g;
    print TARGET "print", " \'", $lines, "\';\n";
    close TARGET;
    chmod 0777, $target;

    next unless -e $errout;
    $target =~ s/\.pl$/_run.pl/;
    # handle any run files likewise
    open TARGET, "> $target" || die "Unable to write to $target: $!";
    print TARGET "#!/usr/bin/perl -w
use strict;

# Send $output to a web screen
";
    $lines = File::Slurp::read_file($errout);
    $lines =~ s/\'/\\\'/g;
    $lines =~ s/method=\'POST/method=\'GET/g;
    print TARGET "print", " \'", $lines, "\';\n";
    close TARGET;
    chmod 0777, $target;
}

my $query = CGI->new();
print $query->header,
      $query->start_html("Display Output for testing"),
      $query->h1("Choose an output file to see below");

my $myself = $query->self_url;
foreach my $output (@output) {
    $errout = $target = $output;
    $target =~ s/\.out$/.pl/;
    $errout =~ s/\.out$/.run/;
    print $query->p("<A href=\"$target\">$output</A>\n");
    next unless -e $errout;
    $target =~ s/\.pl$/_run.pl/;
    print $query->p("<A href=\"$target\">$errout</A>\n");
}
print $query->end_html;

