#!/usr/bin/perl -w

package main;
use strict;

use Test::More tests => 6;
use constant DEBUG => 0;

# force the output to return for testing
$ENV{CGI_APP_RETURN_ONLY} = 1;

# make explicit the query string
$ENV{REQUEST_METHOD} = 'GET';

BEGIN {
  use_ok('CGI::Application');
  use_ok('CGI');
  use_ok('CGI::FormBuilder');
  use_ok('Handout');
  use_ok('File::Slurp');
}

{
        my $param = shift || "";
        my $redo = ( $param =~ /-r/ ) || 0;

	my $wa = Handout->new( QUERY => CGI->new( { rm => 'select_topics',
				_submit => 'Select Info',
				handout_name => 'TCM_Foods',
				 } ) );

        my $source = "";
        my @lines  = ();
        my @items  = ();
	my $okay   = 0;
      
	# registion confirmed output: <n>dw from cut and paste
        $ENV{QUERY_STRING}   = '_submitted_select_topics=1&_sessionid=&topic_1=Weak+%2F+Damp+Spleen&rm=select_topics&handout_name=TCM_Foods&_submit=Select+Info';
        print "QS: $ENV{QUERY_STRING}\n" if DEBUG; 
        $source = $0;				# program name
        $source =~ s/cgi$/out/;
        $okay = run( $source, $wa, \@lines, \@items );
        my $name = $source;
        $name =~ s/\.out$//;
        $name =~ s/^t\///;
        $name =~ s/_/ /g;
	ok($okay, "Test " . $name );

# run_command($command,$host,$init_timeout,$timeout);
    sub run {
   	my ($source, $ca, $lines, $items) = @_;

        my $target = $source;
        $target =~ s/out$/run/;
	unlink $target;

	# create target output 
        @$lines = $ca->run();
	# replace any changeable data here like time/date for DATE
#        $lines->[0] =~ s/received ... ...  \d+ \d+:\d+:\d+ \d+\./received DATE./;
	# read and write to have lines of data
	File::Slurp::write_file($target, @$lines);
	@$lines = File::Slurp::read_file($target);

	# Re-create source only if told or it is not there
	if ( ! -e $source || $redo ) {
	    @$items = $ca->run();
	    # replace any changeable data here like time/date for DATE
#	    $items->[0] =~ s/received ... ...  \d+ \d+:\d+:\d+ \d+\./received DATE./;
	    File::Slurp::write_file($source, @$items);
	    @$items = File::Slurp::read_file($source);
	} else {
	    @$items = File::Slurp::read_file($source);
	}

	# compare sources
        my $okay = eq_array($lines,$items);
	if ( $okay ) {
	    unlink $target;
	} else {
	    diag("Source differed, see $target");
        }
	return $okay;
    }
}

__END__
